###############
rm(list=ls())
###############
# Read data into R's memory
X <- read.table('ChlorellaGrowth.txt')
X <- as.matrix(X)
Light <- X[,1]
rmax <- X[,2] 

par(cex= 1.5, cex.main= 0.9) # optional arguments for plot aesthetics
# xlab and ylab are x and y axis labels, pch is "plotting character"
# cex is 'character expansion' - cex=1.5 increases symbol & label sizes by 50%
# cex.main sets the character expansion for the main title of the plot 
plot(Light, rmax, xlab= "Light intensity (uE/m2/s)", ylab= "Maximum growth rate rmax (1/d)", main= "Data from Fussmann et al. (2000) system", pch= 16) 

# perform the linear model 'lm' 
fit <- lm(rmax ~ Light)
summary(fit)    # return the specifics of the model
abline(fit)     # plot the regression on the still open plot above

# Next we get the regression equation to 'display itself' on the graph
c1= round(coef(fit)[1], digits=3) 	# intercept	
c2= round(coef(fit)[2], digits=3) 	# slope
text(50, 3, paste("rmax=",c1,"+",c2,"* Light")) 

# You can use ?round, ?text and ?paste to read about these commands for working with plots  
